//: ## ![3DaysOfSwift.com Logo](3DaysIcon46.png) Control Flow
//:
//: There are two types of control flow that support optional binding.
//:
//: 1. If statement
//:
//: 2. Guard statement
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


// The `guard` statement is a great choice for optional binding as it exposes the local variable to be used outside of it's `else` branch of code.
func multiplyValueByTenIfItExists(_ optional: Int?) -> Int? {
    guard var unwrappedValue = optional else {
        return
    }
    
    // the value is now available for the rest of the function
    unwrappedValue *= 10
    return unwrappedValue
}

print(multiplyValueByTenIfItExists(10))


//:
//: -------------------
//:
//: ## Task:
//:
//: In the code area below, write a function to multiply an input parameter by 6 using a guard statement.
//:
//: The input parameter is an optional integer.
//:
//: -------------------
//:
//: [◀ Previous Page](@previous) | [Next Page  ▶](@next)
//:
//: -------------------
//:


// write code here










